<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AuthIdentityModel;

class Auth extends BaseController
{
    public function password()
    {
        $user = auth()->user();
        if (!$user) return redirect()->to('/login');

        $identity = (new AuthIdentityModel())
            ->where('user_id', $user->id)
            ->where('type', 'email_password')
            ->first();

        return view('admin/password', [
            'user' => $user,
            'identity' => $identity
        ]);
    }

    public function updatePassword()
    {
        $user = auth()->user();
        if (!$user) {
            return redirect()->to('/login');
        }
    
        $model = new AuthIdentityModel();
    
        $identity = $model
            ->where('user_id', $user->id)
            ->where('type', 'email_password')
            ->first();
    
        if (!$identity) {
            return redirect()->back()->with('error', 'Data akun tidak ditemukan');
        }
    
        $oldPassword = $this->request->getPost('old_password');
        $newPassword = $this->request->getPost('new_password');
        $confirm     = $this->request->getPost('confirm_password');
    
        // cek password lama
        if (!password_verify($oldPassword, $identity['secret2'])) {
            return redirect()->back()->with('error', 'Password lama salah');
        }
    
        // cek konfirmasi
        if ($newPassword !== $confirm) {
            return redirect()->back()->with('error', 'Konfirmasi password tidak cocok');
        }
    
        // update password
        $model->update($identity['id'], [
            'secret2' => password_hash($newPassword, PASSWORD_DEFAULT),
        ]);
    
        return redirect()->back()->with('success', 'Password berhasil diubah');
    }
    

    // ================= UPDATE EMAIL =================
    public function updateEmail()
    {
        $user = auth()->user();
        if (!$user) {
            return redirect()->to('/login');
        }
    
        $model = new AuthIdentityModel();
    
        $identity = $model
            ->where('user_id', $user->id)
            ->where('type', 'email_password')
            ->first();
    
        if (!$identity) {
            return redirect()->back()->with('error', 'Data akun tidak ditemukan');
        }
    
        $email = trim($this->request->getPost('email'));
    
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return redirect()->back()->with('error', 'Format email tidak valid');
        }
    
        // cek email sudah dipakai
        $cek = $model
            ->where('secret', $email)
            ->where('id !=', $identity['id'])
            ->first();
    
        if ($cek) {
            return redirect()->back()->with('error', 'Email sudah digunakan');
        }
    
        $model->update($identity['id'], [
            'secret' => $email
        ]);
    
        return redirect()->back()->with('success', 'Email berhasil diubah');
    }
}    